/*
 * errorLogger.hpp
 *
 *  Created on: Oct 19, 2009
 *      Author: metzler
 */

#ifndef ERRORLOGGER_HPP_
#define ERRORLOGGER_HPP_

#include <iostream>

using namespace std;

class Verbose;

class errorLogger {
public :
  static ostream *nix;
  static int verbosity;

  static errorLogger* getInstance();
  static void purgeInstance();
  static bool DoOutput();
  static void setVerbosity(int verbosityLevel);

protected:
  /** Do not call this constructor directly, use getInstance() instead. */
  errorLogger();
  /** Do not call this destructor directly, use purgeInstance() instead. */
  ~errorLogger();

private:
  static errorLogger* instance;
};

ostream& operator<<(class errorLogger&l, const Verbose& ost);
ostream& operator<<(class errorLogger*l, const Verbose& ost);

#endif /* ERRORLOGGER_HPP_ */
