/*
 * CommandLineParser.hpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

#ifndef COMMANDLINEPARSER_HPP_
#define COMMANDLINEPARSER_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <boost/program_options.hpp>

namespace po = boost::program_options;

#include "CodePatterns/Singleton.hpp"
#include "UIElements/CommandLineUI/TypeEnumContainer.hpp"

#include <map>

namespace MoleCuilder {
  class Action;
  class OptionTrait;
}
class CommandLineParser_ActionRegistry_ConsistenyTest;

/** This class is a wrapper for boost::program_options.
 *
 */
class CommandLineParser : public Singleton<CommandLineParser> {
  friend class Singleton<CommandLineParser>;

  //!> test needs to access CmdParserLookup to see whether menus are missing
  friend class CommandLineParser_ActionRegistry_ConsistencyTest;
public:

  // Parses the command line arguments in CommandLineParser::**argv with currently known options.
  void Run(int _argc, char **_argv);

  // Initialises all options from ActionRegistry.
  void InitializeCommandArguments();

  // Checks whether there have been any commands on the command line.
  bool isEmpty();

  /* boost's program_options are sorted into three categories:
   * -# generic options: option available to both command line and config
   * -# config options: only available in the config file
   * -# hidden options: options which the user is not shown on "help"
   */
  po::options_description analysis;
  po::options_description atom;
  po::options_description bond;
  po::options_description command;
  po::options_description edit;
  po::options_description fill;
  po::options_description shape;
  po::options_description fragmentation;
  po::options_description graph;
  po::options_description molecule;
  po::options_description options;
  po::options_description parser;
  po::options_description potential;
  po::options_description selection;
  po::options_description tesselation;
  po::options_description world;

  po::options_description visible;

  po::variables_map vm;

  // private sequence of actions as they appeared on the command line
  std::list<std::string> SequenceOfActions;

private:
  // private constructor and destructor
  CommandLineParser();
  virtual ~CommandLineParser();

  /* The following program_options options_decriptions are used to
   * generate the various cases and call differently in Parse().
   */
  po::options_description cmdline_options;
  po::options_description config_file_options;

  // adds options to the parser
  void AddOptionToParser(const MoleCuilder::OptionTrait * const currentOption, po::options_description* OptionList);

  // creates a map from short forms to action tokens needed to parse command line
  std::map <std::string, std::string> getShortFormToActionMap() const;

  typedef std::map< std::string , po::options_description *> CmdParserLookupMap;

  // lookup list from "configmenus" to the ones of CommandLineParser
  CmdParserLookupMap CmdParserLookup;

  // Sets the options from the three cases.
  void setOptions(int _argc, char **_argv);

  // Parses all options from command line and config file
  bool Parse();

  // as boost's program_options does not care about of order of appearance but we do for actions,
  // we have to have a list and a function to obtain it.
  void scanforSequenceOfArguments();

  TypeEnumContainer TypeToEnums;

  // argument counter and array passed on from main()
  int argc;
  char **argv;
};

#endif /* COMMANDLINEPARSER_HPP_ */
