/*
 * Values.hpp
 *
 *  Created on: Jun 7, 2010
 *      Author: heber
 */

#ifndef VALUES_HPP_
#define VALUES_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "LinearAlgebra/defs.hpp"

class Box;
class BoxVector;
class Vector;

/** This is just a temporary container for values parsed from the command line.
 * I.e. this is only used within CommandLineParser, where VectorType and alikes
 * are registered as VectorValue and lateron inside the CommandLineQuery placed
 * into the real vector.
 */
struct VectorValue
{
  double vector[NDIM];

  Vector toVector() const;
  BoxVector toBoxVector(Box &_box) const;
};

/** This is just a temporary container for values parsed from the command line.
 * I.e. this is only used within CommandLineParser, where BoxType is registered
 * as BoxValue and lateron inside the CommandLineQuery placed into the real Box.
 */
struct BoxValue
{
  double matrix[(NDIM*(NDIM+1))/2];

  Box toBox() const;
};


#endif /* VALUES_HPP_ */
