/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * ActionMenuItem.cpp
 *
 *  Created on: Dec 11, 2009
 *      Author: crueger
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <iostream>

#include "Menu/TextMenu/ActionMenuItem.hpp"
#include "Actions/Action.hpp"
#include "Actions/ActionQueue.hpp"

using namespace MoleCuilder;

ActionMenuItem::ActionMenuItem(char _trigger, const std::string &_description,TxMenu* const _menu,const std::string &_ActionName)
: MenuItem(_trigger,_description,_menu),
  ActionName(_ActionName)
{
}

ActionMenuItem::~ActionMenuItem()
{}

void ActionMenuItem::doTrigger() {
  ActionQueue::getInstance().queueAction(ActionName);
}

bool ActionMenuItem::isActive() {
  Action* action = ActionQueue::getInstance().getActionByName(ActionName);
  return action->isActive();
}
