/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * VectorsTextQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include <iostream>

#include "TextUI/Query/TextQuery.hpp"

#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "LinearAlgebra/Matrix.hpp"
#include "World.hpp"


TextDialog::VectorsTextQuery::VectorsTextQuery(std::string title, bool _check, std::string _description) :
    Dialog::VectorsQuery(title,_check,_description)
{}

TextDialog::VectorsTextQuery::~VectorsTextQuery()
{}

bool TextDialog::VectorsTextQuery::handle() {
  std::cout << getDescription() << std::endl;
  char coords[3] = {'x', 'y', 'z'};
  const Matrix &M = World::getInstance().getDomain().getM();
  for (int i=0;i<3;i++)
    std::cout << coords[i] << "[0.." << M.at(i,i) << ( (i!=2) ? "], " : "]: ");

  std::string line;
  getline(std::cin,line);

  // dissect by ","
  double coord = 0.;
  std::string::iterator olditerspace = line.begin();
  std::string::iterator olditercomma = line.begin();
  int counter = 0;
  for(string::iterator vectoriter = line.begin(); vectoriter != line.end(); ++vectoriter) {
    if (*vectoriter == ',')
      counter++;
    if ((*vectoriter == ' ') && (counter == 2)) {
      counter = 0;
      for(string::iterator componentiter = olditerspace; (componentiter != vectoriter) && (counter !=3); ++componentiter) {
        if (*componentiter == ',') {
          std::istringstream stream(string(componentiter, olditercomma));
          stream >> coord;
          temp[counter++] = coord;
          olditercomma = componentiter;
        }
      }
      if ((olditercomma != line.begin()) && (counter != 3)) { // insert last part also
        std::istringstream stream(string(olditercomma, vectoriter));
        stream >> coord;
        temp[counter++] = coord;
      }
      if (World::getInstance().getDomain().isInside(temp))
        tmp.push_back(temp);
      olditerspace = vectoriter;
    }
  }

  return true;
}

