/*
 * ContinuousValueTest.hpp
 *
 *  Created on: Sep 29, 2011
 *      Author: heber
 */
#ifndef CONTINUOUSVALUETEST_HPP_
#define CONTINUOUSVALUETEST_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>

#include <cppunit/extensions/HelperMacros.h>

#include "LinearAlgebra/Vector.hpp"

template<class T> struct range;
class Vector;

class ContinuousValueTest :  public CppUnit::TestFixture
{
  CPPUNIT_TEST_SUITE( ContinuousValueTest ) ;
  CPPUNIT_TEST ( isValidIntAsStringTest );
  CPPUNIT_TEST ( isValidIntTest );
  CPPUNIT_TEST ( setgetValidIntRangeTest );
  CPPUNIT_TEST ( settergetterIntAsStringTest );
  CPPUNIT_TEST ( settergetterIntTest );
  CPPUNIT_TEST ( comparatorIntTest );
  CPPUNIT_TEST ( isValidVectorAsStringTest );
  CPPUNIT_TEST ( isValidVectorTest );
  CPPUNIT_TEST ( setgetValidVectorRangeTest );
  CPPUNIT_TEST ( settergetterVectorAsStringTest );
  CPPUNIT_TEST ( settergetterVectorTest );
  CPPUNIT_TEST ( comparatorVectorTest );
  CPPUNIT_TEST_SUITE_END();

public:
  void setUp();
  void tearDown();

  void isValidIntAsStringTest();
  void isValidIntTest();
  void setgetValidIntRangeTest();
  void settergetterIntAsStringTest();
  void settergetterIntTest();
  void comparatorIntTest();

  void isValidVectorAsStringTest();
  void isValidVectorTest();
  void setgetValidVectorRangeTest();
  void settergetterVectorAsStringTest();
  void settergetterVectorTest();
  void comparatorVectorTest();

private:
  range<int> *ValidIntRange;
  range<Vector> *ValidVectorRange;
};

#endif /* CONTINUOUSVALUETEST_HPP_ */
