/*
 * SetOutputFormatsAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/WorldAction/SetOutputFormatsAction.hpp"
#include "Actions/ActionRegistry.hpp"
#include "Parser/ChangeTracker.hpp"
#include "Parser/FormatParserStorage.hpp"
#include "log.hpp"
#include "verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "UIElements/ValueStorage.hpp"

const char WorldSetOutputFormatsAction::NAME[] = "set-output";

WorldSetOutputFormatsAction::WorldSetOutputFormatsAction() :
  Action(NAME)
{}

WorldSetOutputFormatsAction::~WorldSetOutputFormatsAction()
{}

void WorldSetOutputFormats(vector<std::string> &FormatList) {
  ValueStorage::getInstance().setCurrentValue(WorldSetOutputFormatsAction::NAME, FormatList);
  ActionRegistry::getInstance().getActionByName(WorldSetOutputFormatsAction::NAME)->call(Action::NonInteractive);
};

Dialog* WorldSetOutputFormatsAction::fillDialog(Dialog *dialog) {
  ASSERT(dialog,"No Dialog given when filling action dialog");

  dialog->queryStrings(NAME, ValueStorage::getInstance().getDescription(NAME));

  return dialog;
}

Action::state_ptr WorldSetOutputFormatsAction::performCall() {
  vector<std::string> FormatList;

  ValueStorage::getInstance().queryCurrentValue(NAME, FormatList);

  for (vector<std::string>::iterator iter = FormatList.begin(); iter != FormatList.end(); ++iter) {
    if (*iter == "mpqc") {
      FormatParserStorage::getInstance().addMpqc();
      DoLog(0) && (Log() << Verbose(0) << "Adding mpqc type to output." << endl);
    } else if (*iter == "pcp") {
      FormatParserStorage::getInstance().addPcp();
      DoLog(0) && (Log() << Verbose(0) << "Adding pcp type to output." << endl);
    } else if (*iter == "tremolo") {
      FormatParserStorage::getInstance().addTremolo();
      DoLog(0) && (Log() << Verbose(0) << "Adding tremolo type to output." << endl);
    } else if (*iter == "xyz") {
      FormatParserStorage::getInstance().addXyz();
      DoLog(0) && (Log() << Verbose(0) << "Adding xyz type to output." << endl);
    } else {
      DoeLog(1) && (eLog() << Verbose(1) << "Unknown format:" << *iter << endl);
    }
  }
  ChangeTracker::getInstance().saveStatus();
  return Action::success;
}

Action::state_ptr WorldSetOutputFormatsAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr WorldSetOutputFormatsAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool WorldSetOutputFormatsAction::canUndo() {
  return false;
}

bool WorldSetOutputFormatsAction::shouldUndo() {
  return false;
}

const string WorldSetOutputFormatsAction::getName() {
  return NAME;
}
