/*
 * RemoveSphereOfAtomsAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/WorldAction/RemoveSphereOfAtomsAction.hpp"
#include "Actions/ActionRegistry.hpp"
#include "Descriptors/AtomDescriptor.hpp"
#include "atom.hpp"
#include "log.hpp"
#include "molecule.hpp"
#include "vector.hpp"
#include "verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "UIElements/ValueStorage.hpp"

const char WorldRemoveSphereOfAtomsAction::NAME[] = "remove-sphere";

WorldRemoveSphereOfAtomsAction::WorldRemoveSphereOfAtomsAction() :
  Action(NAME)
{}

WorldRemoveSphereOfAtomsAction::~WorldRemoveSphereOfAtomsAction()
{}

void WorldRemoveSphereOfAtoms(double radius, Vector &point) {
  ValueStorage::getInstance().setCurrentValue(WorldRemoveSphereOfAtomsAction::NAME, radius);
  ValueStorage::getInstance().setCurrentValue("position", point);
  ActionRegistry::getInstance().getActionByName(WorldRemoveSphereOfAtomsAction::NAME)->call(Action::NonInteractive);
};

Dialog* WorldRemoveSphereOfAtomsAction::fillDialog(Dialog *dialog) {
  ASSERT(dialog,"No Dialog given when filling action dialog");

  dialog->queryDouble(NAME, ValueStorage::getInstance().getDescription(NAME));
  dialog->queryVector("position", false, ValueStorage::getInstance().getDescription("position"));

  return dialog;
}

Action::state_ptr WorldRemoveSphereOfAtomsAction::performCall() {
  double radius = 0.;
  Vector point;

  ValueStorage::getInstance().queryCurrentValue(NAME, radius);
  ValueStorage::getInstance().queryCurrentValue("position", point);

  DoLog(1) && (Log() << Verbose(1) << "Removing atoms around " << point << " with radius " << radius << "." << endl);
  vector<atom*> AllAtoms = World::getInstance().getAllAtoms();
  vector<molecule *> molecules = World::getInstance().getAllMolecules();
  for (vector<atom*>::iterator AtomRunner = AllAtoms.begin(); AtomRunner != AllAtoms.end(); ++AtomRunner) {
    if (point.DistanceSquared((*AtomRunner)->x) > radius*radius) { // distance to first above radius ...
      // TODO: This is not necessary anymore when atoms are completely handled by World (create/destroy and load/save)
      for (vector<molecule *>::iterator iter = molecules.begin();iter != molecules.end();++iter)
        (*iter)->erase(*AtomRunner);
      World::getInstance().destroyAtom(*AtomRunner);
    }
  }
  return Action::success;
}

Action::state_ptr WorldRemoveSphereOfAtomsAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr WorldRemoveSphereOfAtomsAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool WorldRemoveSphereOfAtomsAction::canUndo() {
  return false;
}

bool WorldRemoveSphereOfAtomsAction::shouldUndo() {
  return false;
}

const string WorldRemoveSphereOfAtomsAction::getName() {
  return NAME;
}
