/*
 * InputAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/WorldAction/InputAction.hpp"
#include "Actions/ActionRegistry.hpp"
#include "log.hpp"
#include "molecule.hpp"
#include "Parser/FormatParserStorage.hpp"
#include "Parser/PcpParser.hpp"
#include "verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "UIElements/ValueStorage.hpp"

const char WorldInputAction::NAME[] = "input";

WorldInputAction::WorldInputAction() :
  Action(NAME)
{}

WorldInputAction::~WorldInputAction()
{}

void WorldInput(std::string &filename) {
  ValueStorage::getInstance().setCurrentValue(WorldInputAction::NAME, filename);
  ActionRegistry::getInstance().getActionByName(WorldInputAction::NAME)->call(Action::NonInteractive);
};

Dialog* WorldInputAction::fillDialog(Dialog *dialog) {
  ASSERT(dialog,"No Dialog given when filling action dialog");

  dialog->queryString(NAME, ValueStorage::getInstance().getDescription(NAME));

  return dialog;
}

Action::state_ptr WorldInputAction::performCall() {
  MoleculeListClass *molecules = World::getInstance().getMolecules();
  molecule *mol = NULL;
  std::string filename;
  std::ifstream test;

  ValueStorage::getInstance().queryCurrentValue(NAME, filename);

  DoLog(0) && (Log() << Verbose(0) << "Config file given." << endl);
  if (filename.find('.') != string::npos) {
    std::string FilenamePrefix = filename.substr(0,filename.find_last_of('.'));
    std::string FilenameSuffix = filename.substr(filename.find_last_of('.')+1, filename.length());
    DoLog(1) && (Log() << Verbose(1) << "Setting config file name prefix to " << FilenamePrefix << "." << endl);
    test.open(filename.c_str());
    if (test == NULL) {
      DoLog(1) && (Log() << Verbose(1) << "Specified config file " << filename << " not found." << endl);
    } else {
      DoLog(1) && (Log() << Verbose(1) << "Specified config file found, parsing ... ");
      FormatParserStorage::getInstance().get((std::istream &)test, FilenameSuffix);
      test.close();
    }
    FormatParserStorage::getInstance().SetOutputPrefixForAll(FilenamePrefix);
    // set mol to first active molecule
    if (molecules->ListOfMolecules.size() != 0) {
      for (MoleculeList::iterator ListRunner = molecules->ListOfMolecules.begin(); ListRunner != molecules->ListOfMolecules.end(); ListRunner++)
        if ((*ListRunner)->ActiveFlag) {
          mol = *ListRunner;
          break;
        }
    }
    if (mol == NULL) {
      mol = World::getInstance().createMolecule();
      mol->ActiveFlag = true;
      molecules->insert(mol);
    }
    mol->SetNameFromFilename(filename.substr(0,filename.find('.')).c_str());
  } else {
    DoeLog(1) && (eLog() << Verbose(1) << "Input file does not have a suffix, cannot recognize format." << endl);
  }
  return Action::success;
}

Action::state_ptr WorldInputAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr WorldInputAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool WorldInputAction::canUndo() {
  return false;
}

bool WorldInputAction::shouldUndo() {
  return false;
}

const string WorldInputAction::getName() {
  return NAME;
}
