/*
 * ChangeBoxAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/WorldAction/ChangeBoxAction.hpp"
#include "Actions/ActionRegistry.hpp"
#include "log.hpp"
#include "verbose.hpp"
#include "World.hpp"
#include "Box.hpp"
#include "Matrix.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "UIElements/ValueStorage.hpp"

const char WorldChangeBoxAction::NAME[] = "change-box";

WorldChangeBoxAction::WorldChangeBoxAction() :
  Action(NAME)
{}

WorldChangeBoxAction::~WorldChangeBoxAction()
{}

void WorldChangeBox(Box &_box) {
  ValueStorage::getInstance().setCurrentValue(WorldChangeBoxAction::NAME, _box);
  ActionRegistry::getInstance().getActionByName(WorldChangeBoxAction::NAME)->call(Action::NonInteractive);
};

Dialog* WorldChangeBoxAction::fillDialog(Dialog *dialog) {
  ASSERT(dialog,"No Dialog given when filling action dialog");

  dialog->queryBox(NAME, ValueStorage::getInstance().getDescription(NAME));

  return dialog;
}

Action::state_ptr WorldChangeBoxAction::performCall() {

  Box cell_size;
  ValueStorage::getInstance().queryCurrentValue(NAME, cell_size);
  World::getInstance().setDomain(cell_size.getM()); // this is needed as only this function is OBSERVEd.

  DoLog(0) && (Log() << Verbose(0) << "Setting box domain to " << World::getInstance().getDomain().getM() << endl);
  return Action::success;
}

Action::state_ptr WorldChangeBoxAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr WorldChangeBoxAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool WorldChangeBoxAction::canUndo() {
  return false;
}

bool WorldChangeBoxAction::shouldUndo() {
  return false;
}

const string WorldChangeBoxAction::getName() {
  return NAME;
}
