/*
 * CenterInBoxAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/WorldAction/CenterInBoxAction.hpp"
#include "Actions/ActionRegistry.hpp"
#include "Box.hpp"
#include "log.hpp"
#include "molecule.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "UIElements/ValueStorage.hpp"

const char WorldCenterInBoxAction::NAME[] = "center-in-box";

WorldCenterInBoxAction::WorldCenterInBoxAction() :
  Action(NAME)
{}

WorldCenterInBoxAction::~WorldCenterInBoxAction()
{}

void WorldCenterInBox(Box &_box) {
  ValueStorage::getInstance().setCurrentValue(WorldCenterInBoxAction::NAME, _box);
  ActionRegistry::getInstance().getActionByName(WorldCenterInBoxAction::NAME)->call(Action::NonInteractive);
};

Dialog* WorldCenterInBoxAction::fillDialog(Dialog *dialog) {
  ASSERT(dialog,"No Dialog given when filling action dialog");

  dialog->queryBox(NAME, ValueStorage::getInstance().getDescription(NAME));

  return dialog;
}

Action::state_ptr WorldCenterInBoxAction::performCall() {

  Box& cell_size = World::getInstance().getDomain();
  ValueStorage::getInstance().queryCurrentValue(NAME, cell_size);
  World::getInstance().setDomain(cell_size.getM());

  // center
  vector<molecule *> AllMolecules = World::getInstance().getAllMolecules();
  for (vector<molecule*>::iterator MolRunner = AllMolecules.begin(); MolRunner != AllMolecules.end(); ++MolRunner) {
    (*MolRunner)->CenterInBox();
  }
  return Action::success;
}

Action::state_ptr WorldCenterInBoxAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr WorldCenterInBoxAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool WorldCenterInBoxAction::canUndo() {
  return false;
}

bool WorldCenterInBoxAction::shouldUndo() {
  return false;
}

const string WorldCenterInBoxAction::getName() {
  return NAME;
}
