/*
 * VerletIntegrationAction.cpp
 *
 *  Created on: May 10, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/MoleculeAction/VerletIntegrationAction.hpp"
#include "Actions/ActionRegistry.hpp"
#include "log.hpp"
#include "molecule.hpp"
#include "verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <fstream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "UIElements/ValueStorage.hpp"

/****** MoleculeVerletIntegrationAction *****/

// memento to remember the state when undoing

//class MoleculeVerletIntegrationState : public ActionState {
//public:
//  MoleculeVerletIntegrationState(molecule* _mol,std::string _lastName) :
//    mol(_mol),
//    lastName(_lastName)
//  {}
//  molecule* mol;
//  std::string lastName;
//};

const char MoleculeVerletIntegrationAction::NAME[] = "verlet-integrate";

MoleculeVerletIntegrationAction::MoleculeVerletIntegrationAction() :
  Action(NAME)
{}

MoleculeVerletIntegrationAction::~MoleculeVerletIntegrationAction()
{}

void MoleculeVerletIntegration(std::string &forcesfile) {
  ValueStorage::getInstance().setCurrentValue(MoleculeVerletIntegrationAction::NAME, forcesfile);
  ActionRegistry::getInstance().getActionByName(MoleculeVerletIntegrationAction::NAME)->call(Action::NonInteractive);
};

Dialog* MoleculeVerletIntegrationAction::fillDialog(Dialog *dialog) {
  ASSERT(dialog,"No Dialog given when filling action dialog");

  dialog->queryString(NAME, ValueStorage::getInstance().getDescription(NAME));

  return dialog;
}

Action::state_ptr MoleculeVerletIntegrationAction::performCall() {
  string filename;
  molecule *mol = NULL;

  ValueStorage::getInstance().queryCurrentValue(NAME, filename);

  for (World::MoleculeSelectionIterator iter = World::getInstance().beginMoleculeSelection(); iter != World::getInstance().endMoleculeSelection(); ++iter) {
    mol = iter->second;
    DoLog(1) && (Log() << Verbose(1) << "Parsing forces file and Verlet integrating." << endl);
    // TODO: sollte besser stream nutzen, nicht filename direkt (es sei denn, ist prefix), besser fuer unit test
    char outputname[MAXSTRINGSIZE];
    strcpy(outputname, filename.c_str());
    if (!mol->VerletForceIntegration(outputname, *(World::getInstance().getConfig()), 0))
      DoLog(2) && (Log() << Verbose(2) << "File not found." << endl);
    else
      DoLog(2) && (Log() << Verbose(2) << "File found and parsed." << endl);
  }
  return Action::success;
}

Action::state_ptr MoleculeVerletIntegrationAction::performUndo(Action::state_ptr _state) {
//  MoleculeVerletIntegrationState *state = assert_cast<MoleculeVerletIntegrationState*>(_state.get());

//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);

  return Action::failure;
}

Action::state_ptr MoleculeVerletIntegrationAction::performRedo(Action::state_ptr _state){
  // Undo and redo have to do the same for this action
  return performUndo(_state);
}

bool MoleculeVerletIntegrationAction::canUndo() {
  return false;
}

bool MoleculeVerletIntegrationAction::shouldUndo() {
  return false;
}

const string MoleculeVerletIntegrationAction::getName() {
  return NAME;
}
