/*
 * SuspendInWaterAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/MoleculeAction/SuspendInWaterAction.hpp"
#include "Actions/ActionRegistry.hpp"
#include "boundary.hpp"
#include "config.hpp"
#include "log.hpp"
#include "verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "UIElements/ValueStorage.hpp"

/****** MoleculeSuspendInWaterAction *****/

// memento to remember the state when undoing

//class MoleculeSuspendInWaterState : public ActionState {
//public:
//  MoleculeSuspendInWaterState(molecule* _mol,std::string _lastName) :
//    mol(_mol),
//    lastName(_lastName)
//  {}
//  molecule* mol;
//  std::string lastName;
//};

const char MoleculeSuspendInWaterAction::NAME[] = "suspend-in-water";

MoleculeSuspendInWaterAction::MoleculeSuspendInWaterAction() :
  Action(NAME)
{}

MoleculeSuspendInWaterAction::~MoleculeSuspendInWaterAction()
{}

void MoleculeSuspendInWater(double density) {
  ValueStorage::getInstance().setCurrentValue(MoleculeSuspendInWaterAction::NAME, density);
  ActionRegistry::getInstance().getActionByName(MoleculeSuspendInWaterAction::NAME)->call(Action::NonInteractive);
};

Dialog* MoleculeSuspendInWaterAction::fillDialog(Dialog *dialog) {
  ASSERT(dialog,"No Dialog given when filling action dialog");

  dialog->queryDouble(NAME, ValueStorage::getInstance().getDescription(NAME));

  return dialog;
}

Action::state_ptr MoleculeSuspendInWaterAction::performCall() {
  molecule *mol = NULL;
  double density;
  double volume = 0.;

  ValueStorage::getInstance().queryCurrentValue(NAME, density);

  for (World::MoleculeSelectionIterator iter = World::getInstance().beginMoleculeSelection(); iter != World::getInstance().endMoleculeSelection(); ++iter) {
    mol = iter->second;
    DoLog(0) && (Log() << Verbose(0) << "Evaluating necessary cell volume for a cluster suspended in water.");
    if (density < 1.0) {
      DoeLog(1) && (eLog()<< Verbose(1) << "Density must be greater than 1.0g/cm^3!" << endl);
    } else {
      PrepareClustersinWater(World::getInstance().getConfig(), mol, volume, density);  // if volume == 0, will calculate from ConvexEnvelope
    }
  }
  return Action::success;
}

Action::state_ptr MoleculeSuspendInWaterAction::performUndo(Action::state_ptr _state) {
//  MoleculeSuspendInWaterState *state = assert_cast<MoleculeSuspendInWaterState*>(_state.get());

//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);

  return Action::failure;
}

Action::state_ptr MoleculeSuspendInWaterAction::performRedo(Action::state_ptr _state){
  // Undo and redo have to do the same for this action
  return performUndo(_state);
}

bool MoleculeSuspendInWaterAction::canUndo() {
  return false;
}

bool MoleculeSuspendInWaterAction::shouldUndo() {
  return false;
}

const string MoleculeSuspendInWaterAction::getName() {
  return NAME;
}
