/*
 * SaveTemperatureAction.cpp
 *
 *  Created on: May 10, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/MoleculeAction/SaveTemperatureAction.hpp"
#include "Actions/ActionRegistry.hpp"
#include "log.hpp"
#include "molecule.hpp"
#include "verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <fstream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "UIElements/ValueStorage.hpp"

/****** MoleculeSaveTemperatureAction *****/

// memento to remember the state when undoing

//class MoleculeSaveTemperatureState : public ActionState {
//public:
//  MoleculeSaveTemperatureState(molecule* _mol,std::string _lastName) :
//    mol(_mol),
//    lastName(_lastName)
//  {}
//  molecule* mol;
//  std::string lastName;
//};

const char MoleculeSaveTemperatureAction::NAME[] = "save-temperature";

MoleculeSaveTemperatureAction::MoleculeSaveTemperatureAction() :
  Action(NAME)
{}

MoleculeSaveTemperatureAction::~MoleculeSaveTemperatureAction()
{}

void MoleculeSaveTemperature(std::string &temperaturefile) {
  ValueStorage::getInstance().setCurrentValue(MoleculeSaveTemperatureAction::NAME, temperaturefile);
  ActionRegistry::getInstance().getActionByName(MoleculeSaveTemperatureAction::NAME)->call(Action::NonInteractive);
};

Dialog* MoleculeSaveTemperatureAction::fillDialog(Dialog *dialog) {
  ASSERT(dialog,"No Dialog given when filling action dialog");

  dialog->queryString(NAME, ValueStorage::getInstance().getDescription(NAME));

  return dialog;
}

Action::state_ptr MoleculeSaveTemperatureAction::performCall() {
  string filename;
  molecule *mol = NULL;

  ValueStorage::getInstance().queryCurrentValue(NAME, filename);

  for (World::MoleculeSelectionIterator iter = World::getInstance().beginMoleculeSelection(); iter != World::getInstance().endMoleculeSelection(); ++iter) {
    mol = iter->second;
    DoLog(1) && (Log() << Verbose(1) << "Storing temperatures in " << filename << "." << endl);
    ofstream output;
    output.open(filename.c_str(), ios::trunc);
    if (output.fail() || !mol->OutputTemperatureFromTrajectories((ofstream * const) &output, 0, mol->MDSteps))
      DoLog(2) && (Log() << Verbose(2) << "File could not be written." << endl);
    else
      DoLog(2) && (Log() << Verbose(2) << "File stored." << endl);
    output.close();
  }
  return Action::success;
}

Action::state_ptr MoleculeSaveTemperatureAction::performUndo(Action::state_ptr _state) {
//  MoleculeSaveTemperatureState *state = assert_cast<MoleculeSaveTemperatureState*>(_state.get());

//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);

  return Action::failure;
}

Action::state_ptr MoleculeSaveTemperatureAction::performRedo(Action::state_ptr _state){
  // Undo and redo have to do the same for this action
  return performUndo(_state);
}

bool MoleculeSaveTemperatureAction::canUndo() {
  return false;
}

bool MoleculeSaveTemperatureAction::shouldUndo() {
  return false;
}

const string MoleculeSaveTemperatureAction::getName() {
  return NAME;
}
