/*
 * ChangeNameAction.hpp
 *
 *  Created on: Jan 15, 2010
 *      Author: crueger
 */

#ifndef CHANGENAMEACTION_HPP
#define CHANGENAMEACTION_HPP

#include "Actions/Action.hpp"
#include "Actions/Process.hpp"

class MoleculeListClass;

void MoleculeChangeName(std::string &name);

class MoleculeChangeNameAction : public Action {
  friend void MoleculeChangeName(std::string &name);

public:
  MoleculeChangeNameAction();
  virtual ~MoleculeChangeNameAction();

  bool canUndo();
  bool shouldUndo();

  virtual const std::string getName();
protected:
  virtual Dialog * fillDialog(Dialog *dialog);
private:
  virtual Action::state_ptr performCall();
  virtual Action::state_ptr performUndo(Action::state_ptr);
  virtual Action::state_ptr performRedo(Action::state_ptr);

  MoleculeListClass *molecules;
  static const char NAME[];
};


#endif // CHANGENAMEACTION_HPP
