/*
 * ChangeNameAction.cpp
 *
 *  Created on: Jan 15, 2010
 *      Author: crueger
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/MoleculeAction/ChangeNameAction.hpp"
#include "Actions/ActionRegistry.hpp"
#include "atom.hpp"
#include "molecule.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "UIElements/ValueStorage.hpp"

/****** MoleculeChangeNameAction *****/

// memento to remember the state when undoing

class MoleculeChangeNameState : public ActionState {
public:
  MoleculeChangeNameState(molecule* _mol,std::string _lastName) :
    mol(_mol),
    lastName(_lastName)
  {}
  molecule* mol;
  std::string lastName;
};

const char MoleculeChangeNameAction::NAME[] = "change-molname";

MoleculeChangeNameAction::MoleculeChangeNameAction() :
  Action(NAME)
{}

MoleculeChangeNameAction::~MoleculeChangeNameAction()
{}

void MoleculeChangeName(std::string &name) {
  ValueStorage::getInstance().setCurrentValue(MoleculeChangeNameAction::NAME, name);
  ActionRegistry::getInstance().getActionByName(MoleculeChangeNameAction::NAME)->call(Action::NonInteractive);
};

Dialog* MoleculeChangeNameAction::fillDialog(Dialog *dialog) {
  ASSERT(dialog,"No Dialog given when filling action dialog");

  dialog->queryString(NAME, ValueStorage::getInstance().getDescription(NAME));

  return dialog;
}

Action::state_ptr MoleculeChangeNameAction::performCall() {
  string filename;
  molecule *mol = NULL;

  ValueStorage::getInstance().queryCurrentValue(NAME, filename);

  if (World::getInstance().countSelectedMolecules() == 1) {
    mol = World::getInstance().beginMoleculeSelection()->second;
    string oldName = mol->getName();
    mol->setName(filename);
    return Action::state_ptr(new MoleculeChangeNameState(mol,oldName));
  } else
    return Action::failure;
}

Action::state_ptr MoleculeChangeNameAction::performUndo(Action::state_ptr _state) {
  MoleculeChangeNameState *state = assert_cast<MoleculeChangeNameState*>(_state.get());

  string newName = state->mol->getName();
  state->mol->setName(state->lastName);

  return Action::state_ptr(new MoleculeChangeNameState(state->mol,newName));
}

Action::state_ptr MoleculeChangeNameAction::performRedo(Action::state_ptr _state){
  // Undo and redo have to do the same for this action
  return performUndo(_state);
}

bool MoleculeChangeNameAction::canUndo() {
  return true;
}

bool MoleculeChangeNameAction::shouldUndo() {
  return true;
}

const string MoleculeChangeNameAction::getName() {
  return NAME;
}
