/*
 * BondFileAction.hpp
 *
 *  Created on: May 10, 2010
 *      Author: heber
 */

#ifndef BONDFILEACTION_HPP
#define BONDFILEACTION_HPP

#include "Actions/Action.hpp"
#include "Actions/Process.hpp"

class MoleculeListClass;

void MoleculeBondFile(std::string &bondfile);

class MoleculeBondFileAction : public Action {
  friend void MoleculeBondFile(std::string &bondfile);

public:
  MoleculeBondFileAction();
  virtual ~MoleculeBondFileAction();

  bool canUndo();
  bool shouldUndo();

  virtual const std::string getName();
protected:
  virtual Dialog * fillDialog(Dialog *dialog);
private:
  virtual Action::state_ptr performCall();
  virtual Action::state_ptr performUndo(Action::state_ptr);
  virtual Action::state_ptr performRedo(Action::state_ptr);

  static const char NAME[];
};


#endif // BONDFILEACTION_HPP
