/*
 * VerboseAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/CmdAction/VerboseAction.hpp"
#include "Actions/ActionRegistry.hpp"
#include "log.hpp"
#include "verbose.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "UIElements/ValueStorage.hpp"

// memento to remember the state when undoing

class CommandLineVerboseState : public ActionState {
public:
  CommandLineVerboseState(int _verbosity) :
    verbosity(_verbosity)
  {}
  int verbosity;
};


const char CommandLineVerboseAction::NAME[] = "verbose";

CommandLineVerboseAction::CommandLineVerboseAction() :
  Action(NAME)
{}

CommandLineVerboseAction::~CommandLineVerboseAction()
{}

void CommandVerbose(int verbosity) {
  ValueStorage::getInstance().setCurrentValue(CommandLineVerboseAction::NAME, verbosity);
  ActionRegistry::getInstance().getActionByName(CommandLineVerboseAction::NAME)->call(Action::NonInteractive);
};

Dialog* CommandLineVerboseAction::fillDialog(Dialog *dialog) {
  ASSERT(dialog,"No Dialog given when filling action dialog");

  dialog->queryInt(NAME, ValueStorage::getInstance().getDescription(NAME));

  return dialog;
}

Action::state_ptr CommandLineVerboseAction::performCall() {
  int verbosity = 2;

  ValueStorage::getInstance().queryCurrentValue(NAME, verbosity);

  setVerbosity(verbosity);
  DoLog(0) && (Log() << Verbose(0) << "Setting verbosity to " << verbosity << "." << endl);
  return Action::success;
}

Action::state_ptr CommandLineVerboseAction::performUndo(Action::state_ptr _state) {
  CommandLineVerboseState *state = assert_cast<CommandLineVerboseState*>(_state.get());

  int verbosity = 2;
  ValueStorage::getInstance().queryCurrentValue(NAME, verbosity);

  setVerbosity(state->verbosity);
  return Action::state_ptr(new CommandLineVerboseState(verbosity));
}

Action::state_ptr CommandLineVerboseAction::performRedo(Action::state_ptr _state){
  performUndo(_state);
}

bool CommandLineVerboseAction::canUndo() {
  return true;
}

bool CommandLineVerboseAction::shouldUndo() {
  return true;
}

const string CommandLineVerboseAction::getName() {
  return NAME;
}
