/*
 * ElementDbAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/CmdAction/ElementDbAction.hpp"
#include "Actions/ActionRegistry.hpp"
#include "config.hpp"
#include "log.hpp"
#include "periodentafel.hpp"
#include "verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "UIElements/ValueStorage.hpp"

const char CommandLineElementDbAction::NAME[] = "element-db";

CommandLineElementDbAction::CommandLineElementDbAction() :
  Action(NAME)
{}

CommandLineElementDbAction::~CommandLineElementDbAction()
{}

void CommandElementDb(std::string &databasepath) {
  ValueStorage::getInstance().setCurrentValue(CommandLineElementDbAction::NAME, databasepath);
  ActionRegistry::getInstance().getActionByName(CommandLineElementDbAction::NAME)->call(Action::NonInteractive);
};

Dialog* CommandLineElementDbAction::fillDialog(Dialog *dialog) {
  ASSERT(dialog,"No Dialog given when filling action dialog");

  dialog->queryString(NAME, ValueStorage::getInstance().getDescription(NAME));

  return dialog;
}

Action::state_ptr CommandLineElementDbAction::performCall() {
  ostringstream usage;
  string databasepath;

  // get the path
  // TODO: Make databasepath a std::string
  config *configuration = World::getInstance().getConfig();
  ValueStorage::getInstance().queryCurrentValue(NAME, databasepath);
  strcpy(configuration->databasepath, databasepath.c_str());

  // load table
  periodentafel *periode = World::getInstance().getPeriode();
  if (periode->LoadPeriodentafel(configuration->databasepath)) {
    DoLog(0) && (Log() << Verbose(0) << "Element list loaded successfully." << endl);
    //periode->Output();
    return Action::success;
  } else {
    DoLog(0) && (Log() << Verbose(0) << "Element list loading failed." << endl);
    return Action::failure;
  }

}

Action::state_ptr CommandLineElementDbAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr CommandLineElementDbAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool CommandLineElementDbAction::canUndo() {
  return false;
}

bool CommandLineElementDbAction::shouldUndo() {
  return false;
}

const string CommandLineElementDbAction::getName() {
  return NAME;
}
