/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * ParserTremolo_ElementKeysUnitTest.cpp
 *
 *  Created on: Mar 3, 2010
 *      Author: metzler
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "ParserTremolo_ElementKeysUnitTest.hpp"

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include "Atom/atom.hpp"
#include "Descriptors/AtomTypeDescriptor.hpp"
#include "Element/element.hpp"
#include "Element/periodentafel.hpp"
#include "Parser/TremoloParser.hpp"
#include "Parser/TremoloParser_ElementKeys.hpp"
#include "Parser/ChangeTracker.hpp"
#include "Potentials/Particles/ParticleRegistry.hpp"
#include "World.hpp"
#include "WorldTime.hpp"

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

using namespace std;

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( ParserTremolo_ElementKeysUnitTest );
void ParserTremolo_ElementKeysUnitTest::setUp()
{
  knownTypes = new ElementKeys();
}

void ParserTremolo_ElementKeysUnitTest::tearDown()
{
  ParticleRegistry::purgeInstance();
  WorldTime::purgeInstance();
  World::purgeInstance();

  delete knownTypes;
}

/************************************ tests ***********************************/

void ParserTremolo_ElementKeysUnitTest::settergetterTest()
{
  // install a key
  CPPUNIT_ASSERT_NO_THROW( knownTypes->setType("H1", "H"));

  // check for excepetion
  CPPUNIT_ASSERT_THROW( knownTypes->setType("H1", "H"), IllegalParserKeyException);

  // get present key
  CPPUNIT_ASSERT_NO_THROW( knownTypes->getType("H1"));

  // get non-present key
  CPPUNIT_ASSERT_THROW( knownTypes->getType("F"), IllegalParserKeyException);
}
