/*
 * ParserUnitTest.hpp
 *
 *  Created on: Mar 3, 2010
 *      Author: metzler
 */
#ifndef PARSERUNITTEST_HPP_
#define PARSERUNITTEST_HPP_

#include <cppunit/extensions/HelperMacros.h>
#include <string>

class ParserUnitTest :  public CppUnit::TestFixture
{
  CPPUNIT_TEST_SUITE( ParserUnitTest ) ;
  CPPUNIT_TEST ( rewriteAnXyzTest );
  CPPUNIT_TEST ( readTremoloPreliminaryCommentsTest );
  CPPUNIT_TEST ( readTremoloCoordinatesTest );
  CPPUNIT_TEST ( readTremoloVelocityTest );
  CPPUNIT_TEST ( readTremoloNeighborInformationTest );
  CPPUNIT_TEST ( readAndWriteTremoloImprDataInformationTest );
  CPPUNIT_TEST ( readAndWriteTremoloTorsionInformationTest );
  CPPUNIT_TEST ( writeTremoloTest );
  CPPUNIT_TEST ( readwritePcpTest );
  CPPUNIT_TEST ( writeMpqcTest );
  CPPUNIT_TEST_SUITE_END();

public:
  void setUp();
  void tearDown();

  void rewriteAnXyzTest();
  void readTremoloPreliminaryCommentsTest();
  void readTremoloCoordinatesTest();
  void readTremoloVelocityTest();
  void readTremoloNeighborInformationTest();
  void readAndWriteTremoloImprDataInformationTest();
  void readAndWriteTremoloTorsionInformationTest();
  void writeTremoloTest();
  void readwritePcpTest();
  void writeMpqcTest();
};

#endif /* PARSERUNITTEST_HPP_ */
