/*
 * MpqcParser.hpp
 *
 *  Created on: 12.06.2010
 *      Author: heber
 */

#ifndef MPQCPARSER_HPP_
#define MPQCPARSER_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/toString.hpp"

#include "FormatParser.hpp"
#include "FormatParserTrait.hpp"
#include "FormatParserInterface.hpp"
#include "FormatParser_common.hpp"
#include "ParserTypes.hpp"

#include "MpqcParser_Parameters.hpp"

#include <iosfwd>

class Vector;

// declaration of specialized FormatParserTrait
template<>
struct FormatParserTrait<mpqc>
{
  //!> Name of the parser
  static const std::string name;
  //!> suffix of the files the parser understands to read and write
  static const std::string suffix;
  //!> ParserTypes enumeration for the parser
  static const enum ParserTypes type;
};

/**
 * Loads a MPQC config file into the World and saves the World as a tremolo file.
 */
template <>
class FormatParser< mpqc >  : virtual public FormatParserInterface, public FormatParser_common
{
  friend class ParserMpqcUnitTest;
public:
  FormatParser();
  virtual ~FormatParser();

  void load(std::istream *file);
  void save(std::ostream *file, const std::vector<atom *> &atoms); 

  /** Getter for parameter set.
   *
   * @return reference to parameter class
   */
  MpqcParser_Parameters & getParams() { return *static_cast<MpqcParser_Parameters *>(parameters); }

private:
  void OutputMPQCLine(ostream * const out, const atom &_atom, const Vector *center) const;

  static ConvertTo<bool> Converter;
};


#endif /* MPQCPARSER_HPP_ */
