/*
 * AtomicInstance_impl.hpp
 *
 *  Created on: Apr 26, 2016
 *      Author: heber
 */


#ifndef ATOMICINSTANCE_IMPL_HPP_
#define ATOMICINSTANCE_IMPL_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/Assert.hpp"

#include "AtomicInstance.hpp"

template<class T> boost::mutex AtomicInstance< T >::atomicLock;

template <class T>
AtomicInstance<T>::AtomicInstance(T* _content) :
    content(_content)
{
  if (content != NULL)
    AtomicInstance<T>::atomicLock.lock();
}

template <class T>
AtomicInstance<T>::AtomicInstance() :
    content(NULL)
{
}

template <class T>
AtomicInstance<T>::~AtomicInstance()
{
  if (content != NULL)
    AtomicInstance<T>::atomicLock.unlock();
}

template <class T>
T& AtomicInstance<T>::operator*()
{ return *content;}

template <class T>
const T& AtomicInstance<T>::operator*() const
{ return *content;}

template <class T>
AtomicInstance<T>& AtomicInstance<T>::operator=(const AtomicInstance<T>& rhs)
{
  if (this != &rhs) {
    this->content = rhs.content;
    const_cast<AtomicInstance<T>&>(rhs).content = NULL;
  }
  return *this;
}

template <class T>
AtomicInstance<T>::AtomicInstance(AtomicInstance<T>& rhs) :
    content(rhs.content)
{
  // check for self-copy
  if (this != &rhs)
    rhs.content = NULL;
}

template <class T>
AtomicInstance<T>::AtomicInstance(const AtomicInstance<T>& rhs) :
    content(rhs.content)
{
  // check for self-copy
  ASSERT (this != &rhs,
      "AtomicInstance<T>::AtomicInstance() - self-assignment not allowed for rhs copy.");
  const_cast<AtomicInstance<T>&>(rhs).content = NULL;
}

#endif /* ATOMICINSTANCE_IMPL_HPP_ */
