/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * TremoloAtomInfoContainer.cpp
 *
 *  Created on: Dec 7, 2010
 *      Author: heber
 */

#include "TremoloAtomInfoContainer.hpp"

#include <iostream>


TremoloAtomInfoContainer::TremoloAtomInfoContainer() :
  F("0"),
  stress("0"),
  imprData("-"),
  GroupMeasureTypeNo("0"),
  extType("-"),
  name("-"),
  resName("-"),
  chainID("0"),
  resSeq("0"),
  occupancy("0"),
  tempFactor("0"),
  segID("0"),
  Charge("0"),
  charge("0"),
  GrpTypeNo("0"),
  torsion("-"),
  neighbors(std::vector<int>(0, 5))
{}

void TremoloAtomInfoContainer::set(TremoloKey::atomDataKey key, std::string value) {
  switch (key) {
    case TremoloKey::F :
      F = value;
      break;
    case TremoloKey::stress :
      stress = value;
     break;
    case TremoloKey::imprData :
      imprData = value;
      break;
    case TremoloKey::GroupMeasureTypeNo :
      GroupMeasureTypeNo = value;
      break;
    case TremoloKey::extType :
      extType = value;
      break;
    case TremoloKey::name :
      name = value;
      break;
    case TremoloKey::resName :
      resName = value;
      break;
    case TremoloKey::chainID :
      chainID = value;
      break;
    case TremoloKey::resSeq :
      resSeq = value;
      break;
    case TremoloKey::occupancy :
      occupancy = value;
      break;
    case TremoloKey::tempFactor :
      tempFactor = value;
      break;
    case TremoloKey::segID :
      segID = value;
      break;
    case TremoloKey::Charge :
      Charge = value;
      break;
    case TremoloKey::charge :
      charge = value;
      break;
    case TremoloKey::GrpTypeNo :
      GrpTypeNo = value;
      break;
    case TremoloKey::torsion :
      torsion = value;
      break;
    default :
      std::cout << "Unknown key: " << key << ", value: " << value << std::endl;
      break;
  }
}

std::string TremoloAtomInfoContainer::get(TremoloKey::atomDataKey key) {
  switch (key) {
    case TremoloKey::F :
      return F;
    case TremoloKey::stress :
      return stress;
    case TremoloKey::imprData :
      return imprData;
    case TremoloKey::GroupMeasureTypeNo :
      return GroupMeasureTypeNo;
    case TremoloKey::extType :
      return extType;
    case TremoloKey::name :
      return name;
    case TremoloKey::resName :
      return resName;
    case TremoloKey::chainID :
      return chainID;
    case TremoloKey::resSeq :
      return resSeq;
    case TremoloKey::occupancy :
      return occupancy;
    case TremoloKey::tempFactor :
      return tempFactor;
    case TremoloKey::segID :
      return segID;
    case TremoloKey::Charge :
      return Charge;
    case TremoloKey::charge :
      return charge;
    case TremoloKey::GrpTypeNo :
      return GrpTypeNo;
    case TremoloKey::torsion :
      return torsion;
    default :
      std::cout << "Unknown key: " << key << std::endl;
      return "";
  }
}

