/*
 * QtDialog.hpp
 *
 *  Created on: Jan 18, 2010
 *      Author: crueger
 */

#ifndef QTDIALOG_HPP_
#define QTDIALOG_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include "UIElements/Dialog.hpp"
#include <QtGui/QDialog>

#include <map>
#include <set>
#include <vector>

class QBoxLayout;
class QDialogButtonBox;

class QtDialog : public QDialog, public Dialog
{
  Q_OBJECT
public:
  QtDialog();
  virtual ~QtDialog();

  virtual void queryEmpty(const char*, std::string);
  virtual void queryBoolean(const char *, std::string = "");
  virtual void queryInt(const char *,std::string = "");
  virtual void queryInts(const char *,std::string = "");
  virtual void queryDouble(const char*,std::string = "");
  virtual void queryDoubles(const char*,std::string = "");
  virtual void queryString(const char*,std::string = "");
  virtual void queryStrings(const char*,std::string = "");
  virtual void queryAtom(const char*,std::string = "");
  virtual void queryAtoms(const char*,std::string = "");
  virtual void queryMolecule(const char*,std::string = "");
  virtual void queryMolecules(const char*,std::string = "");
  virtual void queryVector(const char*,bool,std::string = "");
  virtual void queryVectors(const char*,bool,std::string = "");
  virtual void queryBox(const char*, std::string = "");
  virtual void queryElement(const char*,std::string = "");
  virtual void queryElements(const char*,std::string = "");
  virtual void queryFile(const char*,std::string = "");
  virtual void queryRandomNumberDistribution_Parameters(const char*,std::string = "");

  virtual bool display();

  virtual void update();

protected:
  class AtomQtQuery;
  class AtomsQtQuery;
  class BooleanQtQuery;
  class BoxQtQuery;
  class DoubleQtQuery;
  class DoublesQtQuery;
  class ElementQtQuery;
  class ElementsQtQuery;
  class EmptyQtQuery;
  class FileQtQuery;
  class IntQtQuery;
  class IntsQtQuery;
  class MoleculeQtQuery;
  class MoleculesQtQuery;
  class StringQtQuery;
  class StringsQtQuery;
  class VectorQtQuery;
  class VectorsQtQuery;
  class RandomNumberDistribution_ParametersQtQuery;

private:
  QBoxLayout *mainLayout;
  QBoxLayout *inputLayout;
  QBoxLayout *buttonLayout;
  QDialogButtonBox *buttons;
};


#endif /* QTDIALOG_HPP_ */
