/*
 * GLMoleculeObject_atom.hpp
 *
 *  Created on: Aug 17, 2011
 *      Author: heber
 */

#ifndef GLMOLECULEOBJECT_ATOM_HPP_
#define GLMOLECULEOBJECT_ATOM_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "GLMoleculeObject.hpp"

#include "CodePatterns/ObservedValue.hpp"
#include "CodePatterns/Observer/Observer.hpp"

#include "LinearAlgebra/Vector.hpp"

#include "Bond/bond.hpp"
#include "UIElements/Views/Qt4/Qt3D/GLMoleculeObject_bond.hpp"
#include "types.hpp"

class GLWorldScene;

class GLMoleculeObject_atom : public GLMoleculeObject, Observer
{
  Q_OBJECT
public:
  GLMoleculeObject_atom(QGLSceneNode *mesh[], QObject *parent, const atomId_t id);
  virtual ~GLMoleculeObject_atom();

  void draw(QGLPainter *painter, const QVector4D &cameraPlane);

  // Observer functions
  void update(Observable *publisher);
  void subjectKilled(Observable *publisher);
  void recieveNotification(Observable *publisher, Notification_ptr notification);

public slots:
  void Selected();
  void Unselected();

private slots:
  void wasClicked();
  void resetIndex();
  void resetElement();
  void resetPosition();
  void resetBonds();

signals:
  void clicked(atomId_t);
  void BondsAdded(const atomId_t _left, const atomId_t _right, const GLMoleculeObject_bond::SideOfBond side);
  void BondsRemoved(const atomId_t _left, const atomId_t _right);
  void indexChanged(GLMoleculeObject_atom *ob, const atomId_t oldId, const atomId_t newId);
  void idChanged();
  void positionChanged();
  void elementChanged();
  void bondsChanged();

private:
  //!> grant GLMoleculeObject_molecule acess to reset functions
  friend class GLMoleculeObject_molecule;

  //!> typedef for list of bonds, defined by pairs of atom ids
  typedef std::vector< std::pair<atomId_t, atomId_t> > ListOfBonds_t;

  static const atom * const getAtomConst(const atomId_t _id);
  static atom * const getAtom(const atomId_t _id);

  atomId_t updateIndex() const;
  Vector updatePosition() const;
  atomicNumber_t updateElement() const;
  ListOfBonds_t updateBonds() const;

  void activateObserver();
  void deactivateObserver();

private:

  //!> current list of bonds to compare new onw against for changes
  ListOfBonds_t ListOfBonds;

  //!> temporary variable used in cstor
  atom * const atomref;

  //!> cached value of the atom's id
  ObservedValue<atomId_t> AtomIndex;
  //!> cached value of the atom's position
  ObservedValue<Vector> AtomPosition;
  //!> cached value of the atom's element
  ObservedValue<atomicNumber_t> AtomElement;
  //!> cached value of the atom's id
  ObservedValue<ListOfBonds_t> AtomBonds;

  //!> list of channels when index needs to update
  static const Observable::channels_t AtomIndexChannels;
  //!> list of channels when position needs to update
  static const Observable::channels_t AtomPositionChannels;
  //!> list of channels when element needs to update
  static const Observable::channels_t AtomElementChannels;
  //!> list of channels when bonds needs to update
  static const Observable::channels_t AtomBondsChannels;

  //!> the Observable we are signed on, also indicates whether we are sign on (not NULL)
  const Observable *owner;
};



#endif /* GLMOLECULEOBJECT_ATOM_HPP_ */
